#!/usr/bin/env bash
set -e

BUILD_CONTAINER_NAME=lambda-build
ARCHIVE_FILE=lambda.zip

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd "$DIR"

rm -rf "${DIR}/lambda/${ARCHIVE_FILE}"

docker build -t "${BUILD_CONTAINER_NAME}-2" -f "${DIR}/.docker/Dockerfile" "${DIR}/.docker"
docker run --rm -i -v "${DIR}/../:/project_root:ro" -v "${DIR}:/src:ro" -v "${DIR}/lambda:/out" --user=root --entrypoint /src/.docker/build.sh "${BUILD_CONTAINER_NAME}-2"

rm -rf "${DIR}/build"
