#!/bin/bash

# Function to prompt user for input with default value
prompt_with_default() {
    local var_name=$1
    local default_value=$2

    # Prompt user for input
    read -p "Enter the value for $var_name [Default: $default_value]: " user_input

    # Set variable to user input or default value if input is empty
    if [ -z "$user_input" ]; then
        eval "$var_name=\"$default_value\""
    else
        eval "$var_name=\"$user_input\""
    fi
}

# uuidgen
UUID_TOKEN=$(uuidgen)
prompt_with_default HOSTNAME "worker-01"
echo "Enabled Services: issuegen, openvpn, wazuh, suricata"
# disable SSL certificate validation as self-signed certs are used
prompt_with_default OVPN_SSL_VERIFY false
prompt_with_default OVPN_URL "https://bastion.tenant1.example.com:8443/"
prompt_with_default OVPN_LOGIN "admin"
prompt_with_default OVPN_PASSWORD "bastion-pass"
# each time generate new OpenVPN certificate
OVPN_CERT_NAME="$HOSTNAME-$UUID_TOKEN"
NODE_NAME="$HOSTNAME"

# Export all variables
export UUID_TOKEN
export HOSTNAME
export DISABLE_SERVICES
export OVPN_SSL_VERIFY
export OVPN_URL
export OVPN_LOGIN
export OVPN_PASSWORD
export OVPN_CERT_NAME
export NODE_NAME

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

rm -rf config-drive build
mkdir -p config-drive/openstack/latest

export DOCKER_CREDENTIALS=''

echo "Retrieving VPN certificate..."
python3 get_ovpn_file.py

# Now load in the Kafka variables
if [ -f ./wazuh.env ]; then
  set -a              # export all following variables
  # shellcheck disable=SC1091
  source ./wazuh.env
  set +a              # stop auto-export
else
  echo "WARNING: wazuh.env not found, Kafka vars missing" >&2
fi

j2 --filters=j2_custom_filters.py files/linux/ubuntu/cloud-init.j2 > config-drive/openstack/latest/user-data
cp files/linux/ubuntu/meta-data config-drive/openstack/latest/meta-data

j2 --filters=j2_custom_filters.py files/linux/ubuntu/bare_metal.sh.j2 > bare_metal.sh
chmod +x bare_metal.sh
