import argparse
import calendar
import re
import time


def semver_gen(m, build=None):
    def build_number(s):
        if build:
            return "%s+%s" % (s, build)
        return s

    major = minor = patch = 0
    if not m:
        return build_number('%s.%s.%s' % (major, minor, patch))
    if m['major']:
        major = m['major']
    if m['minor']:
        minor = m['minor']
    if m['patch']:
        patch = m['patch']
    return build_number('%s.%s.%s' % (major, minor, patch))


def get_timestamp():
    return "%s" % calendar.timegm(time.gmtime())


def get_build_number(a):
    if a.build:
        return a.build
    if a.timestamp_build:
        return get_timestamp()
    return None


parser = argparse.ArgumentParser()
parser.add_argument('--version-string', dest='version_string', required=True)
parser.add_argument('--build', dest='build', default=None)
parser.add_argument('--timestamp-build', dest='timestamp_build', default=False, action='store_true')
args = parser.parse_args()

m = re.search(r'(?P<major>\d+)\.(?P<minor>\d+)(\.(?P<patch>\d+))?', args.version_string)
print(semver_gen(m, build=get_build_number(args)))
