#!/bin/bash

set -e -x

# Disable swap and remove swap partititions
swapoff -a
sed -i '/ swap / s/^\(.*\)$/#\1/g' /etc/fstab

# Set Grub Theme
grub_theme_line='GRUB_THEME="/boot/grub/themes/siemonster/theme.txt"'
echo "$grub_theme_line" | tee -a /etc/default/grub >/dev/null
mkdir -p /boot/grub/themes/siemonster
cp /home/vagrant/vendor/files/linux/ubuntu/theme.txt /boot/grub/themes/siemonster
update-grub

apt install -y wget systemd-timesyncd htop vim tcpdump neofetch net-tools > /dev/null
timedatectl set-ntp true > /dev/null
echo "neofetch --ascii /etc/siemonster/ascii.txt" >> /etc/skel/.bashrc

# https://forum.proxmox.com/threads/cfg80211-failed-to-load-regulatory-db.137298/
wget -qO- https://mirrors.edge.kernel.org/pub/software/network/wireless-regdb/wireless-regdb-2023.09.01.tar.gz | tar -xz --strip-components=1 -C /usr/lib/firmware

echo 'Welcome to Hydra Version 5.08 Debian' | tee /etc/motd > /dev/null
