import base64
import os
import sys

PY3 = sys.version_info[0] >= 3


def wrap_string(s, wrap=None):
    def chunks(s, n):
        for start in range(0, len(s), n):
            yield s[start:start+n]

    if wrap is None:
        return s
    return '\n'.join(chunks(s, wrap))


def b64encode(bytes_or_str, wrap=None):
    if PY3 and isinstance(bytes_or_str, str):
        input_bytes = bytes_or_str.encode('utf8')
    else:
        input_bytes = bytes_or_str

    output_bytes = base64.b64encode(input_bytes)
    if PY3:
        return wrap_string(output_bytes.decode('ascii'), wrap)
    else:
        return wrap_string(output_bytes, wrap)


def insert_b64encode(file_path, wrap=None):
    with open(file_path, "rb") as fn:
        return wrap_string(base64.b64encode(fn.read()).decode(), wrap)


def env_override(value, key):
  return os.getenv(key, value)


def read_file(fname, mode='r'):
    return open(fname, mode).read()


def basename(path):
    return os.path.basename(path)


def dirname(path):
    return os.path.dirname(path)


def tolist(inst):
    if isinstance(inst, list):
        return inst
    return inst.split(',')
